define([
    'underscore',
    'marionette',
    'backbone',
    'Vent',
    'App',
    'modules/page/popup/external-nav-popup-view',
    'modules/form/leave-confirmation/leave-confirmation-popup-view',
    'modules/page/core/behaviors/focus-cc-on-header-behavior',
    'jqm',
],
function(
    _,
    Marionette,
    Backbone,
    vent,
    app,
    ExternalNavigationWarningPopup,
    LeaveConfirmationPopup,
    Focus
) {
    'use strict';
    return Marionette.View.extend({
        className: 'view',
        ui: {
            previous: '#previous-btn',
            continue: '#continue-btn',
            exit: '#exit-btn',
            submit: '#submit-btn',
        },
        events: {
            'click @ui.exit': 'toExit',
            'touchend @ui.continue': 'toContinue',
            'click @ui.continue': 'toContinue',
            'click @ui.previous': 'routeToPrevious',
        },
        behaviors: {
            Focus: {
                behaviorClass: Focus,
            },
        },
        handleModelChange: function() {
            if (this.validator.checkForm()) {
                this.enableContinueButton();
            } else {
                this.disableContinueButton();
            }
        },
        disableContinueButton: function() {
            this.ui.continue.prop('disabled', true);
        },
        enableContinueButton: function() {
            this.ui.continue.prop('disabled', false);
        },
        routeToPrevious: function() {
            vent.trigger('show:previousWizardPage');
        },
        routeToExit: function() {
            window.location.hash = '#';
            app.wizardActive = false;
        },
        onDomRefresh: function() {
            this.handleModelChange();
        },
        openExternalLink: function(e) {
            e.preventDefault();

            // eslint-disable-next-line vars-on-top
            var navigationWarning = new ExternalNavigationWarningPopup({
                elAfterClose: e.currentTarget,
                model: new Backbone.Model({href: $(e.currentTarget).attr('href')}),
            });
            navigationWarning.openPopup();
        },
        toExit: function(e) {
            var leaveConfirmationPopup = new LeaveConfirmationPopup({
                elAfterClose: $(e.currentTarget),
                continue: this.routeToExit,
            });
            leaveConfirmationPopup.openPopup();
        },
    });
});
